
Class Rocket

	Public
	
	Global Player:Rocket ' TODO: Make player reference part of Rocket class

	Property Alive:Bool ()
		Return Not exploded
	End
	
	Property RocketBody:RigidBody ()
		Return body
	End
	
	Property RocketModel:Model ()
		Return model
	End
	
	Property Fuel:Float ()
		Return fuel
		Setter (amount:Float)
			fuel = amount
	End
	
	Property Joy:Joystick ()
		Return joy
	End
	
	Property CurrentOrb:Orb ()
		Return orb
		Setter (torb:Orb)
			orb = torb
	End

	Property OrbActive:Bool ()
		Return orb_toggle
	End
	
	Method New (x:Float, y:Float, z:Float, radius:Float, length:Float, mass:Float)
		
		Local mat:PbrMaterial = New PbrMaterial (Color.Silver)
		mat.MetalnessFactor = 0.85
		
		boost = Sound.Load ("asset::boost.ogg")
		boost_channel = boost.Play (True)
		boost_channel.Volume = 0.0
		
		alert = Sound.Load ("asset::alert.ogg")
		alert_channel = alert.Play (True)
		alert_channel.Volume = 0.0
		
		boom = Sound.Load ("asset::boom.ogg")
		boom_channel = boom.Play (False)
		boom_channel.Paused = True
'		boom_channel.Volume = 0.0

' Can't detect when leaving pad!

'		refuel = Sound.Load ("asset::refuel.ogg")
'		refuel_channel = refuel.Play (True)
		'refuel_channel.Rate = refuel_channel.Rate * 0.85
'		refuel_channel.Volume = 0.0
		
		model = Model.Load ("asset::Rocket_Ship_01.gltf")

		For Local mat:Material = Eachin model.Materials
			Cast <PbrMaterial> (mat).MetalnessFactor = 1.0
		Next
		
'		cone vis:
		
		'Local temp:Model = Model.CreateCone (radius, length, Axis.Y, 32, mat, model)
		'temp.Alpha = 0.25
		
		Local yoff:Float = 0.15
		model.Mesh.FitVertices (New Boxf (-radius, -length * 0.5 - yoff, -radius, radius, length * 0.5 - yoff, radius), False)
		
		' Hmm...
		
'		booster = New Light (model)
'		booster.Type = LightType.Spot ' Directional ' Point
'		booster.Move (0, -2.0, 0)
'		booster.Rotate (90.0, 0.0, 0.0) ' Spotlight down
'		booster.InnerAngle = 5.0
'		booster.OuterAngle = 15.0
'		booster.CastsShadow = True
'		booster.Color = Color.Black
'		booster.Range = 25.0
'		
		' Important: Position BEFORE adding collider/rigid body!
		
		model.Move (x, y + length, z)

		' Add collider shape and rigid body...
		
		collider			= model.AddComponent <ConeCollider> ()
		collider.Radius		= radius
		collider.Length		= length

		body				= model.AddComponent <RigidBody> ()
 		body.Mass			= mass
		body.Restitution	= 0.1
		
		body.AngularDamping	= 0.5
		body.LinearDamping	= 0.15
		
		body.CollisionMask	= COLL_ROCKET
		body.CollisionGroup	= ROCKET_COLLIDES_WITH

		vec_forward			= New Vec3f (torque_factor, 0.0, 0.0)
		vec_backward		= New Vec3f (-torque_factor, 0.0, 0.0)
		vec_left			= New Vec3f (0.0, 0.0, torque_factor)
		vec_right			= New Vec3f (0.0, 0.0, -torque_factor)

		explosion_triggered = False
		
		model.Collided += Lambda (other_body:RigidBody) ' Other colliding body
			
			Select other_body.CollisionMask
			
				Case COLL_PAD
				
					' Landing speed check... TODO: Angle!
					
'					If body.LinearVelocity.Length < 3.0 Then Return ' TODO: Need explosion on pad too
		
					If Not landed
						landed = True ' Can't detect when no longer colliding!
						' Want to play landing 'thump' once
					Endif
				
					fuel = fuel + 0.25
					
					'refuel_channel.Volume = 0.1
					
					If alert_channel.Volume
						If fuel > 25.0 Then alert_channel.Volume = 0.0
					Endif
					
					If fuel > 100 Then fuel = 100'; refuel_channel.Volume = 0.0
				
				Case COLL_TERRAIN

					' Landing speed check... TODO: Angle!
					
					' TODO: Length not suitable! Acceleration into walls sometimes shows this...
					
					#Rem
					
						# https://github.com/blitz-research/monkey2/issues/391
						
						Actually, I'm not sure a plain velocity check is really good enough here, you may
						have to check change in velocity instead, ie: acceleration (or in this case
						decceleration!). The problem is if the rocket in the previous update was *nearly*
						touching the ground, then in the next frame it collides and ends up *just* touching
						ground, it's velocity (ie: change in position) will actually be very small wont it?
						
						In other words, 'current velocity' may not tell you all that much, it will be more
						likely to be 'bigger' the faster you were going before hitting something, but not
						guaranteed to be.

					#End
					
					If body.LinearVelocity.Length < 3.0
						'Print "Too slow"
						Return
					Endif
					
					If Not exploded Then Explode ()
					
			End
			
		End
	
		joy = FindFirstXboxPad ()		
		
	End

	Method Explode ()

		' Calling Scene.Update prevents many tris from falling through terrain...
		
		Game.GameScene.Update ()

		boom_channel.Paused = False
		alert_channel.Paused = True
		
		PhysicsTri.Explode (Self)
		
		model.Visible = False
		
		fuel = 0.0

		orb?.DetachFromRocket ()

		exploded = True
		
	End
	
	Method Control ()

		joy = ValidateJoystick (joy) ' Specifically checks for Xbox pad

		Local boosting:Bool = False
		
		If fuel
		
			' KEYBOARD
			
			If Keyboard.KeyDown (Key.Left)
				PitchLeft (Game.MainCamera, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Right)
				PitchRight (Game.MainCamera, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Up)
				PitchForward (Game.MainCamera, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Down)
				PitchBack (Game.MainCamera, 0.75)
			Endif
	
			If Keyboard.KeyDown (Key.Space)
			
				boosting = True
				
				If boost_channel.Volume < 1.0
					boost_channel.Volume = boost_channel.Volume + 0.1
					If boost_channel.Volume > 1.0 Then boost_channel.Volume = 1.0
				Endif
				
				Boost (0.0, body.Mass * boost_factor, 0.0)
				New SmokeParticle (Self)
				
				fuel = fuel - (0.0375 * 0.5) ' Half full analogue controls' rate
				If fuel < 25.0 Then alert_channel.Volume = 0.2
				
				If fuel < 0.0
					fuel = 0.0
					boost_channel.Volume = 0.0
					boosting = False
				Endif
				
			Endif
			
			' JOYSTICK
			
			If joy And joy.Attached
			
	'			Print joy.GetAxis (0) ' Left stick left/right
				'Print joy.GetAxis (1) ' Left stick up/down (-1 = back, +1 = forward)
				
				Local jpitch:Float = joy.GetAxis (1)
				
				If jpitch > 0.05 Then PitchBack (Game.MainCamera, jpitch)
				If jpitch < -0.05 Then PitchForward (Game.MainCamera, Abs (jpitch))
				
				Local jlr:Float = joy.GetAxis (0)
				
				If jlr > 0.05 Then PitchRight (Game.MainCamera, jlr)
				If jlr < -0.05 Then PitchLeft (Game.MainCamera, Abs (jlr))
				
	'			Print joy.GetAxis (2) ' Left trigger
	'			Print joy.GetAxis (3) ' Right stick left/right
	'			Print joy.GetAxis (4) ' Right stick up/down
	'			Print joy.GetAxis (5) ' Right trigger (-1 = nothing, +1 = full)
	
				Local jyraw:Float = joy.GetAxis (5)
				Local jy:Float = (jyraw + 1) * 0.5
				
				If boost_channel.Volume < jy
					boost_channel.Volume = jy
				Endif
				
	'			Print jy ' 0-2
	'			Print ""
	
	'			If fuel And 
				If jyraw > -1.0
				
					boosting = True
					
					Boost (0.0, (body.Mass * boost_factor) * jy, 0.0)
					New SmokeParticle (Self, jy)
					
					fuel = fuel - (0.0375 * jy)
					If fuel < 25.0 Then alert_channel.Volume = 0.2
					
					If fuel < 0.0
						fuel = 0.0
						boost_channel.Volume = 0.0
						boosting = False
					Endif
					
				Endif
			
			Endif
		
		Endif

		If Not boosting
			boost_channel.Volume = boost_channel.Volume - 0.02
			If boost_channel.Volume < 0.0 Then boost_channel.Volume = 0.0
		Endif
	
	End
	
	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
		boost_channel.Stop ()
		alert_channel.Stop ()
		boom_channel.Stop ()
		boost_channel = Null
		alert_channel = Null
		boom_channel = Null
	End

'	Method ToggleOrb ()
'		orb_toggle = Not orb_toggle
'		Print orb_toggle
'	End

	Field explosion_triggered:Bool
	
	Private
	
	Field model:Model				' mojo3d Model
	Field collider:ConeCollider		' Bullet physics collider
	Field body:RigidBody			' Bullet physics body

	Field boost_factor:Float	= 18.0'0.25
	Field torque_factor:Float	= 90.0

	Field vec_forward:Vec3f
	Field vec_backward:Vec3f
	Field vec_left:Vec3f
	Field vec_right:Vec3f

	' Make Global to load once?
	
	Field boost:Sound
	Field boost_channel:Channel
	
	Field alert:Sound
	Field alert_channel:Channel
	
	Field boom:Sound
	Field boom_channel:Channel
	
	Field refuel:Sound
	Field refuel_channel:Channel
	
'	Field booster:Light
	
	Field fuel:Float = 100.0
	Field exploded:Bool = False
	
	Field landed:Bool = False

	Field joy:Joystick

	Field orb:Orb
	Field orb_toggle:Bool	' TEMP

	Method Boost:Void (force_x:Float = 0.0, force_y:Float = 0.0, force_z:Float = 0.0)
		body.ApplyForce (model.Basis * New Vec3f (force_x, force_y, force_z))
	End

	Method PitchLeft:Void (camera:GameCamera, multi:Float = 1.0)
		body.ApplyTorque (camera.Camera3D.Basis * vec_left * multi)
	End

	Method PitchRight:Void (camera:GameCamera, multi:Float = 1.0)
		body.ApplyTorque (camera.Camera3D.Basis * vec_right * multi)
	End

	Method PitchForward:Void (camera:GameCamera, multi:Float = 1.0)
		body.ApplyTorque (camera.Camera3D.Basis * vec_forward * multi)
	End

	Method PitchBack:Void (camera:GameCamera, multi:Float = 1.0)
		body.ApplyTorque (camera.Camera3D.Basis * vec_backward * multi)
	End

End
